using System;

/*
Primitivst-Laufzeitmessung fr einfache Schleifen.

Der C#-Optimizer krzt keine Leerschleifen raus. Laufzeitunterschiede
zwischen Debug und Release entstehen dadurch, dass bei Optimierung 
CPU-Register fr x,y,z verwendet werden, ohne Optimierung
dagegen Variablen auf dem Stack.
 
*/
namespace Loops_CSharp
{
	/// <summary>
	/// Zusammenfassung fr Class1.
	/// </summary>
	class Class1
	{
		[System.Runtime.InteropServices.DllImport("winmm.dll")]
		private static extern int timeGetTime();

		static void EmptyLoop()
		{
			int STime = timeGetTime();

			for  (int x = 1; x <= 1000; x++)
				for (int y = 1; y <= 1000; y++)
					for (int z = 1; z <= 1000; z++)
						;

			Console.WriteLine("Empty Loops in C#: {0}", 
				timeGetTime()-STime);
		}

		static int CalcLoop()
		{
			int STime = timeGetTime();
			int Res = 0;

			for  (int x = 1; x <= 1000; x++)
				for (int y = 1; y <= 1000; y++)
					for (int z = 1; z <= 1000; z++)
						Res++;

			Console.WriteLine("Calc Loops in C#: {0}", 
				timeGetTime()-STime);

			return(Res);
		}

		static int RealCalcLoop()
		{
			int STime = timeGetTime();
			int Res = 0;

			for  (int x = 1; x <= 1000; x++)
				for (int y = 1; y <= 1000; y++)
					for (int z = 1; z <= 1000; z++)
						Res += (x + y + z) % 4;

			Console.WriteLine("Real Calc Loops in C#: {0}", 
				timeGetTime()-STime);

			return(Res);
		}
		
		[STAThread]
		static void Main(string[] args)
		{ 
			EmptyLoop();
			Console.WriteLine("CalcLoop() returned {0}", CalcLoop());
			Console.WriteLine("RealCalcLoop() returned {0}", RealCalcLoop());
			Console.ReadLine();
		}
	}
}

